<?php
function handle_start($chat_id, $full_name) {
    save_to_db($chat_id, 'user');
    $start_message = (
        "<b>Hi $full_name! Welcome to this bot</b>\n" .
        "<b>━━━━━━━━━━━━━━━━━━━━━━</b>\n" .
        "<b>SmartCC-Gen</b> is your ultimate toolkit on Telegram, packed with cc gen, educational resources, downloaders, temp mail, crypto utilities, and more. Simplify your tasks with cardin ease!\n" .
        "<b>━━━━━━━━━━━━━━━━━━━━━━</b>\n" .
        "<b>Don't forget to <a href=\"" . UPDATES_CHANNEL . "\">JoinNow</a> for updates!</b>"
    );
    $keyboard = [
        'inline_keyboard' => [[
            ['text' => 'Update Channel', 'url' => UPDATES_CHANNEL]
        ]]
    ];
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $start_message,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard),
        'disable_web_page_preview' => true
    ]);
}

function handle_new_chat_members($message, $chat_id) {
    foreach ($message['new_chat_members'] as $new_member) {
        if ($new_member['is_bot'] && $new_member['id'] == json_decode(bot('getMe'), true)['result']['id']) {
            if (save_to_db($chat_id, 'group')) {
                bot('sendMessage', [
                    'chat_id' => $chat_id,
                    'text' => "<b>Thank You For Adding Me In This Group</b>",
                    'parse_mode' => 'HTML',
                    'disable_web_page_preview' => true
                ]);
            }
            break;
        }
    }
}
?>