<?php
// Telegram API call function
function bot($method, $data = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $res = curl_exec($ch);
    if (curl_error($ch)) {
        error_log(curl_error($ch));
    }
    curl_close($ch);
    return $res;
}

// Save user or group to usersdb.txt (prevent duplicates)
function save_to_db($chat_id, $type = 'user') {
    $db_file = USERS_DB;
    $entry = "$chat_id|$type\n";
    if (!file_exists($db_file)) {
        file_put_contents($db_file, '');
    }
    $existing = file_get_contents($db_file);
    if (strpos($existing, "$chat_id|$type") === false) {
        file_put_contents($db_file, $entry, FILE_APPEND | LOCK_EX);
        return true;
    }
    return false;
}

// Luhn Algorithm for validation
function luhn_algorithm($card_number) {
    $digits = str_split(str_replace(' ', '', $card_number));
    $digits = array_map('intval', array_reverse($digits));
    $sum = 0;

    for ($i = 0; $i < count($digits); $i++) {
        if ($i % 2 === 1) {
            $doubled = $digits[$i] * 2;
            $sum += ($doubled > 9) ? ($doubled - 9) : $doubled;
        } else {
            $sum += $digits[$i];
        }
    }

    return $sum % 10 === 0;
}

// Calculate Luhn check digit
function calculate_luhn_check_digit($partial_card_number) {
    $temp_number = $partial_card_number . '0';
    $digits = str_split(str_replace(' ', '', $temp_number));
    $digits = array_map('intval', array_reverse($digits));
    $sum = 0;

    for ($i = 0; $i < count($digits); $i++) {
        if ($i % 2 === 1) {
            $doubled = $digits[$i] * 2;
            $sum += ($doubled > 9) ? ($doubled - 9) : $doubled;
        } else {
            $sum += $digits[$i];
        }
    }

    $check_digit = (10 - ($sum % 10)) % 10;
    return $check_digit;
}

// Generate flag emoji from country code
function get_flag($country_code) {
    if (strlen($country_code) !== 2) return '';
    $offset = 0x1F1E6;
    $first = mb_chr($offset + (ord(strtoupper($country_code[0])) - ord('A')));
    $second = mb_chr($offset + (ord(strtoupper($country_code[1])) - ord('A')));
    return $first . $second;
}

// Get BIN info
function get_bin_info($bin) {
    $apiKey = API_KEY;
    $url = "https://data.handyapi.com/bin/$bin";
    $options = [
        "http" => [
            "method" => "GET",
            "header" => "x-api-key: {$apiKey}\r\n"
        ]
    ];
    $context = stream_context_create($options);
    $response = @file_get_contents($url, false, $context);
    return @json_decode($response, true);
}

// Get fake address
function get_fake_address($country_code) {
    $url = "https://abirthetech.serv00.net/eiin.php?code=" . urlencode($country_code);
    $response = @file_get_contents($url);
    return @json_decode($response, true);
}
?>