<?php
// Copyright @ISmartDevs
// Channel defined in config.php

// Include configuration and all function files
require_once 'config.php';
require_once 'func/func.php';
require_once 'sudo/stats.php';
require_once 'sudo/broadcast.php';
require_once 'gen/gen.php';
require_once 'core/start.php';
require_once 'misc/callback.php';
require_once 'misc/fake.php';
require_once 'misc/info.php';
require_once 'misc/bin.php'; // Added

// Main handler for Telegram updates
$update = json_decode(file_get_contents('php://input'), true);

if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'] ?? '';
    $text = $message['text'] ?? '';
    $first_name = $message['from']['first_name'] ?? 'User';
    $last_name = $message['from']['last_name'] ?? '';
    $full_name = trim("$first_name $last_name");

    // Handle /start command (exact match)
    if (strtolower($text) === '/start') {
        handle_start($chat_id, $full_name);
    }

    // Handle new chat members
    if (isset($message['new_chat_members'])) {
        handle_new_chat_members($message, $chat_id);
    }

    // Handle /stats command
    if ($text === '/stats') {
        handle_stats($chat_id, $user_id);
    }

    // Handle /send command
    if ($text === '/send') {
        handle_send_command($chat_id, $user_id, $message);
    }

    // Handle /gen command
    if (preg_match('/^[\/.!#,]gen/i', $text)) {
        handle_gen_command($chat_id, $text, $user_id);
    }

    // Handle /fake command
    if (preg_match('/^[\/.!#,]fake/i', $text)) {
        handle_fake_command($chat_id, $text);
    }

    // Handle /info or /id command
    if (preg_match('/^[\/.!#,](info|id)/i', $text)) {
        handle_info_command($chat_id, $message);
    }

    // Handle /bin command
    if (preg_match('/^[\/.!#,]bin/i', $text)) {
        handle_bin_command($chat_id, $text, $message['message_id']);
    }
} elseif (isset($update['callback_query'])) {
    // Handle callback queries
    handle_callback_query($update['callback_query']);
}
?>