<?php
// Copyright @ISmartDevs
// BIN lookup handler

function handle_bin_command($chat_id, $text, $message_id) {
    // Extract BIN from command (e.g., /bin 515462, /bin 515462xxx)
    $pattern = '/^[\/.!#,]bin\s*([\dxX]{6,15})?$/i';
    if (!preg_match($pattern, $text, $matches) || empty($matches[1])) {
        // No valid BIN provided
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>🚫 Please Provide A Valid BIN (6-15 digits or x/X)!</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }

    $bin_input = $matches[1];
    // Extract first 6 digits for API call
    $numeric_bin = preg_replace('/[xX]/', '', $bin_input);
    if (strlen($numeric_bin) < 6) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>🚫 BIN must have at least 6 numeric digits!</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }
    $bin = substr($numeric_bin, 0, 6);

    // Send loading message
    $loading = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<b>⏳ Fetching BIN's Details...</b>",
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);

    if (!$loading) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>❌ Error: Could not process request</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }

    $loading = json_decode($loading, true);
    if (!$loading || !isset($loading['result']['message_id'])) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>❌ Error: Invalid response from Telegram</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }
    $loading_message_id = $loading['result']['message_id'];

    // Get BIN info
    $bin_info = get_bin_info($bin);

    if ($bin_info && isset($bin_info['Status']) && strtoupper($bin_info['Status']) === 'SUCCESS') {
        // Format BIN info
        $info = strtoupper(
            ($bin_info['Level'] ?? 'Unknown') . ' ' .
            ($bin_info['Type'] ?? 'Unknown') . ' - ' .
            ($bin_info['Scheme'] ?? 'Unknown')
        );
        $response = "<b>🔍 BIN Details From Database 📋</b>\n";
        $response .= "<b>━━━━━━━━━━━━━━━━</b>\n";
        $response .= "<b>• BIN:</b> <code>$bin_input</code>\n";
        $response .= "<b>• INFO:</b> $info\n";
        $response .= "<b>• BANK:</b> " . strtoupper($bin_info['Issuer'] ?? 'Unknown') . "\n";
        $response .= "<b>• COUNTRY:</b> " . strtoupper($bin_info['Country']['Name'] ?? 'Unknown') . " " . get_flag($bin_info['Country']['A2'] ?? '') . "\n";
        $response .= "<b>━━━━━━━━━━━━━━━━</b>\n";
        $response .= "<b>Don't forget to <a href=\"" . UPDATES_CHANNEL . "\">JoinNow</a> for updates!</b>";

        // Edit loading message with BIN info
        bot('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $loading_message_id,
            'text' => $response,
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    } else {
        // Log error for debugging
        error_log("BIN lookup failed for $bin: " . print_r($bin_info, true));
        // Edit loading message with error
        bot('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $loading_message_id,
            'text' => "<b>❌ Sorry, BIN Not Found In Database</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    }
}
?>