<?php
function handle_callback_query($callback) {
    $chat_id = $callback['message']['chat']['id'];
    $message_id = $callback['message']['message_id'];
    if (strpos($callback['data'], 'regenerate|') === 0) {
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text' => 'Generating Credit Cards'
        ]);
        $user_input = str_replace('_', ' ', substr($callback['data'], 11));
        list($bin, $month, $year, $cvv, $amount) = parse_input($user_input);
        if (!$bin) {
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "<b>Sorry, BIN must be 6-15 digits </b>",
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true
            ]);
            return;
        }
        if ($cvv && (strlen($cvv) < 3 || strlen($cvv) > 4)) {
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "<b>Invalid CVV format. CVV must be 3 or 4 digits ❌</b>",
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true
            ]);
            return;
        }
        if ($amount > CC_GEN_LIMIT) {
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "<b>You can only generate up to 10 credit cards ❌</b>",
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true
            ]);
            return;
        }
        $bin_info = get_bin_info(substr(preg_replace('/[xX]/', '', $bin), 0, 6));
        if (!$bin_info || $bin_info['Status'] !== 'SUCCESS' || !isset($bin_info['Country'])) {
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "<b>❌ Sorry, Invalid BIN Provided</b>",
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true
            ]);
            return;
        }
        $cards = generate_credit_card($bin, $amount, $month, $year, $cvv);
        if (empty($cards)) {
            bot('editMessageText', [
                'chat_id' => $chat_id,
                'message_id' => $message_id,
                'text' => "<b>❌ Invalid BIN length for card type</b>",
                'parse_mode' => 'HTML',
                'disable_web_page_preview' => true
            ]);
            return;
        }
        $callback_data = "regenerate|$user_input";
        $keyboard = [
            'inline_keyboard' => [[[
                'text' => 'Re-Generate',
                'callback_data' => str_replace(' ', '_', $callback_data)
            ]]]
        ];
        bot('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => format_results($bin, $cards, $amount),
            'reply_markup' => json_encode($keyboard),
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    }
}
?>