<?php
function format_address($country_code, $address_data) {
    $country_name = '';
    $street = '';
    $street_name = '';
    $building_number = '';
    $city = '';
    $zipcode = '';
    $country = '';

    if (isset($address_data['status']) && $address_data['status'] === 'OK' && !empty($address_data['data'])) {
        $data = $address_data['data'][0];
        $country_name = $data['country'] ?? 'Unknown';
        $street = $data['street'] ?? 'N/A';
        $street_name = $data['streetName'] ?? 'N/A';
        $building_number = $data['buildingNumber'] ?? 'N/A';
        $city = $data['city'] ?? 'N/A';
        $zipcode = $data['zipcode'] ?? 'N/A';
        $country = $data['country'] ?? 'N/A';
    } elseif (isset($address_data['success']) && $address_data['success'] === true && !empty($address_data['data'])) {
        $data = $address_data['data'][0];
        $country_name = $data['country'] ?? 'Unknown';
        if ($country_code === 'KZ') {
            $street = $data['address'] ?? 'N/A';
            $street_name = 'N/A';
            $building_number = 'N/A';
            $city = $data['city'] ?? 'N/A';
            $zipcode = $data['zipcode'] ?? 'N/A';
            $country = $data['country'] ?? 'N/A';
        } elseif ($country_code === 'DZ') {
            $street = $data['street_1'] ?? 'N/A';
            $street_name = $data['street_2'] ?? 'N/A';
            $building_number = 'N/A';
            $city = $data['city'] ?? 'N/A';
            $zipcode = $data['zipcode'] ?? 'N/A';
            $country = $data['country'] ?? 'N/A';
        }
    } else {
        return "<b>Please Provide A Valid Country Code</b>";
    }

    $text = "<b>Address for $country_name</b>\n";
    $text .= "<b>━━━━━━━━━━━</b>\n";
    $text .= "<b>Street:</b> <code>$street</code>\n";
    $text .= "<b>Street Name:</b> <code>$street_name</code>\n";
    $text .= "<b>Building Number:</b> <code>$building_number</code>\n";
    $text .= "<b>City/Town/Village:</b> <code>$city</code>\n";
    $text .= "<b>Postal code:</b> <code>$zipcode</code>\n";
    $text .= "<b>━━━━━━━━━━━</b>\n";
    $text .= "<b>Country:</b> <code>$country</code>\n";

    return $text;
}

function handle_fake_command($chat_id, $text) {
    save_to_db($chat_id, 'user');
    $loading_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<b>Generating Fake Address...</b>",
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);
    $message_id = json_decode($loading_msg, true)['result']['message_id'];
    $country_code = trim(preg_replace('/^[\/.!#,]fake\s+/i', '', $text));
    if (strlen($country_code) !== 2 || !preg_match('/^[A-Za-z]{2}$/', $country_code)) {
        bot('editMessageText', [
            'chat_id' => $chat_id,
            'message_id' => $message_id,
            'text' => "<b>Please Provide A Valid Country Code</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }
    $address_data = get_fake_address(strtoupper($country_code));
    $formatted_address = format_address(strtoupper($country_code), $address_data);
    bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $message_id,
        'text' => $formatted_address,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);
}
?>