<?php
function handle_info_command($chat_id, $message) {
    save_to_db($chat_id, 'user');
    $user_id = $message['from']['id'] ?? 'Unknown';
    $first_name = $message['from']['first_name'] ?? 'User';
    $last_name = $message['from']['last_name'] ?? '';
    $full_name = trim("$first_name $last_name");
    $username = isset($message['from']['username']) ? '@' . $message['from']['username'] : 'None';
    $chat_type = $message['chat']['type'] ?? 'Unknown';
    $language_code = $message['from']['language_code'] ?? 'Unknown';
    $is_bot = isset($message['from']['is_bot']) && $message['from']['is_bot'] ? 'True' : 'False';
    $current_date = date('d/m/Y');

    // Map language codes to country codes for flag display
    $lang_to_country = [
        'en' => 'US',
        'es' => 'ES',
        'fr' => 'FR',
        'de' => 'DE',
        'it' => 'IT',
        'ru' => 'RU',
        'zh' => 'CN',
        'ja' => 'JP',
        'ko' => 'KR',
        'ar' => 'SA',
        'pt' => 'BR',
        'hi' => 'IN',
    ];

    // Extract base language code (e.g., 'en-US' -> 'en')
    $base_lang = strtolower(preg_replace('/-.*$/', '', $language_code));
    $country_code = $lang_to_country[$base_lang] ?? null;
    $lang_display = $country_code ? get_flag($country_code) : $language_code;

    $text = "✘《 User Information ↯ 》\n";
    $text .= "↯ UserID: $user_id ↯\n";
    $text .= "↯ Full Name: $full_name ↯\n";
    $text .= "↯ UserName: $username ↯\n";
    if ($chat_type !== 'private') {
        $text .= "↯ ChatID: $chat_id ↯\n";
    }
    $text .= "↯ Chat Type: $chat_type ↯\n";
    $text .= "↯ Language Code: $lang_display ↯\n";
    $text .= "↯ Is Bot: $is_bot ↯\n";
    $text .= "↯ Updated at: $current_date ↯\n";

    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '✘ Permanent Link ↯', 'url' => "tg://user?id=$user_id"]
            ]
        ]
    ];

    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard),
        'disable_web_page_preview' => true
    ]);
}
?>