<?php
// Broadcast message to all users and groups
function broadcast_message($message, $chat_id, $message_id) {
    $start_time = microtime(true);
    $db_file = USERS_DB;
    $successful_users = 0;
    $blocked_users = 0;
    $successful_groups = 0;
    $failed_groups = 0;

    $loading_msg = bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => "<b>Sending Broadcast Sir</b>",
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ]);
    $loading_message_id = json_decode($loading_msg, true)['result']['message_id'];

    if (file_exists($db_file)) {
        $lines = array_unique(file($db_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
        foreach ($lines as $line) {
            list($id, $type) = explode('|', $line);
            $result = bot('forwardMessage', [
                'chat_id' => $id,
                'from_chat_id' => $chat_id,
                'message_id' => $message_id
            ]);
            $result = json_decode($result, true);
            if ($result['ok']) {
                if ($type === 'user') {
                    $successful_users++;
                } elseif ($type === 'group') {
                    $successful_groups++;
                }
            } else {
                if ($type === 'user') {
                    $blocked_users++;
                } elseif ($type === 'group') {
                    $failed_groups++;
                }
            }
            usleep(50000); // Prevent rate limiting
        }
    }

    $end_time = microtime(true);
    $time_taken = round($end_time - $start_time, 2);

    $text = "<b>Successfully Broadcast Complete in $time_taken seconds ✅</b>\n";
    $text .= "<b>To Users:</b> <code>$successful_users</code>\n";
    $text .= "<b>Blocked:</b> <code>$blocked_users</code>\n";
    $text .= "<b>To Groups:</b> <code>$successful_groups</code>\n";
    $text .= "<b>Failed Groups:</b> <code>$failed_groups</code>\n";

    $keyboard = [
        'inline_keyboard' => [[
            ['text' => 'Updates Channel', 'url' => UPDATES_CHANNEL]
        ]]
    ];

    bot('editMessageText', [
        'chat_id' => $chat_id,
        'message_id' => $loading_message_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard),
        'disable_web_page_preview' => true
    ]);
}

function handle_send_command($chat_id, $user_id, $message) {
    if ($user_id != OWNER_ID) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>❌ Sorry Bro You're Not Authorized</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }
    if (isset($message['reply_to_message'])) {
        broadcast_message($message, $chat_id, $message['reply_to_message']['message_id']);
    } else {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>Please reply to a message to broadcast.</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
    }
}
?>