<?php
// Get stats from usersdb.txt
function get_stats() {
    $db_file = USERS_DB;
    $total_users = 0;
    $total_groups = 0;
    if (file_exists($db_file)) {
        $lines = file($db_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            list($id, $type) = explode('|', $line);
            if ($type === 'user') {
                $total_users++;
            } elseif ($type === 'group') {
                $total_groups++;
            }
        }
    }
    return ['users' => $total_users, 'groups' => $total_groups];
}

function handle_stats($chat_id, $user_id) {
    if ($user_id != OWNER_ID) {
        bot('sendMessage', [
            'chat_id' => $chat_id,
            'text' => "<b>❌ Sorry Bro You're Not Authorized</b>",
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true
        ]);
        return;
    }
    $stats = get_stats();
    $text = "<b>Statistics For SmartCCGen</b>\n";
    $text .= "<b>━━━━━━━━━━━</b>\n";
    $text .= "<b>Total Users:</b> {$stats['users']}\n";
    $text .= "<b>Total Groups:</b> {$stats['groups']}\n";
    $text .= "<b>━━━━━━━━━━━</b>\n";
    $text .= "<b>Dev By @TheSmartDev</b>\n";
    $keyboard = [
        'inline_keyboard' => [[
            ['text' => 'Updates Channel', 'url' => UPDATES_CHANNEL]
        ]]
    ];
    bot('sendMessage', [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML',
        'reply_markup' => json_encode($keyboard),
        'disable_web_page_preview' => true
    ]);
}
?>